DROP PROCEDURE [hips].[PcehrAuditInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 19 Oct 2012
-- Description:   Inserts a new record into the PcehrAudit Table
-- Modified:
--  4/2/2014 - Simon Biber - Don't return Request/Response to save transfer bandwidth
-- =============================================
CREATE PROCEDURE [hips].[PcehrAuditInsert] 
(
	@PatientMasterId INT,
	@ServiceName VARCHAR(256),
	@ServiceMessage VARCHAR(MAX),
	@Request XML=NULL,
	@Response XML=NULL,
	@Ihi VARCHAR(16),
	@HpiO VARCHAR(16),
	@UserName VARCHAR(256),
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
	
    DECLARE @intErrorCode INT
		,@PcehrAuditId INT

    SET @intErrorCode = 0

    INSERT
     INTO [hips].PcehrAudit
             ( PatientMasterId ,
               ServiceName,
               ServiceMessage,               
               Request ,
               Response ,
               Ihi,
               HpiO,
               UserName,
               DateCreated ,
               UserCreated ,
               DateModified ,
               UserModified
             )
     VALUES  ( @PatientMasterId ,    
               @ServiceName , 
               @ServiceMessage , 
               @Request ,
               @Response ,
               @Ihi ,
               @HpiO ,
               @UserName ,               
               GETDATE() , -- DateCreated - datetime
               @UserModified , -- UserCreated - varchar(256)
               GETDATE() , -- DateModified - datetime
               @UserModified  -- UserModified - varchar(256)
             )
    SELECT @intErrorCode = @@ERROR 
		, @PcehrAuditId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [PcehrAuditId],
		 PatientMasterId ,
               ServiceName,
               ServiceMessage,
               --Request,   -- Don't return request/response to save transfer bandwidth
               --Response,
               Ihi,               
               HpiO ,
               UserName ,
               DateCreated ,
               UserCreated ,
               DateModified ,
               UserModified
         FROM [hips].[PcehrAudit]
         WHERE [PcehrAuditId] = @PcehrAuditId
    END

    RETURN(@intErrorCode)
END
GO

